#include "AudioStack/SMT/clSrcState_RampUpInit.h"
#include "AudioStack/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack
{

//--- Sub-State: RampUpInit ----------------------------------------------------------------------------
void clSrcState_RampUpInit::vEnter(clAudioSource* pclAudioSource, tU32 , tU8 )
{
   if (NULL != pclAudioSource)
   {
      pclAudioSource->vNotifyInitStarted();

      // invoke play on MW-interface
      pclAudioSource->vMW_Init();
   }
}

void clSrcState_RampUpInit::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // go directly to off instead of rampDown because the rampup was not yet started
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData);
}

void clSrcState_RampUpInit::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // go directly to pause instead of rampDown because the rampup was not yet started
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData);
}

void clSrcState_RampUpInit::vMsg_InitDone(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampUpRequesting(), u32UserData);
}

void clSrcState_RampUpInit::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData)
{


   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData);
   // begin sequence again with init
//   if (NULL != pclAudioSource)
//   {
//      pclAudioSource->vNotifyInitStarted();
//
//      // invoke play on MW-interface
//      pclAudioSource->vMW_Init();
//   }
}

}

